<?php
session_start();
require_once(__DIR__ . '/controles/db.php');
require_once(__DIR__ . '/controles/clientes_conexoes.php');
require_once(__DIR__ . '/controles/checkLogout.php');
header('Content-Type: application/json; charset=utf-8');
checkLogoutapi();
if (!isset($_SESSION['nivel_admin']) || $_SESSION['nivel_admin'] !== '1') { echo json_encode(['title'=>'Acesso negado','icon'=>'error']); exit; }
$action = $_POST['action'] ?? '';
$cliente_id = intval($_POST['cliente_id'] ?? 0);
$conexao_id = intval($_POST['conexao_id'] ?? 0);
switch ($action) {
  case 'listar_por_cliente':
    echo json_encode(cc_listar_por_cliente($cliente_id));
    break;
  case 'anexar':
    echo json_encode(cc_anexar($cliente_id, $conexao_id));
    break;
  case 'remover':
    echo json_encode(cc_remover($cliente_id, $conexao_id));
    break;
  case 'definir_limite':
    $limite = isset($_POST['limite']) && $_POST['limite'] !== '' ? intval($_POST['limite']) : null;
    echo json_encode(cc_definir_limite($cliente_id, $limite));
    break;
  default:
    echo json_encode(['title'=>'Ação inválida','icon'=>'error']);
}