<?php
session_start();
require_once(__DIR__ . '/controles/db.php');
require_once(__DIR__ . '/controles/conexoes.php');
require_once(__DIR__ . '/controles/checkLogout.php');
header('Content-Type: application/json; charset=utf-8');
checkLogoutapi();
if (!isset($_SESSION['nivel_admin']) || $_SESSION['nivel_admin'] !== '1') { echo json_encode(['title'=>'Acesso negado','icon'=>'error']); exit; }
$action = $_POST['action'] ?? '';
switch ($action) {
  case 'listar':
    echo json_encode(listar_conexoes());
    break;
  case 'adicionar':
    echo json_encode(adicionar_conexao($_POST));
    break;
  case 'editar':
    echo json_encode(editar_conexao($_POST));
    break;
  case 'deletar':
    echo json_encode(deletar_conexao(intval($_POST['id'] ?? 0)));
    break;
  default:
    echo json_encode([ 'title' => 'Ação inválida', 'icon' => 'error' ]);
}