<?php
function cc_listar_por_cliente($cliente_id) {
  $cx = conectar_bd();
  $st = $cx->prepare('SELECT c.* FROM conexoes_m3u c INNER JOIN clientes_conexoes cc ON cc.conexao_id = c.id WHERE cc.cliente_id = :cid ORDER BY c.nome');
  $st->execute([':cid'=>$cliente_id]);
  return [ 'data' => $st->fetchAll(PDO::FETCH_ASSOC) ];
}
function cc_anexar($cliente_id, $conexao_id) {
  $cx = conectar_bd();
  $q = $cx->prepare('SELECT limite_conexoes FROM clientes WHERE id=:id');
  $q->execute([':id'=>$cliente_id]);
  $limite = $q->fetchColumn();
  if ($limite !== null) {
    $qtd = $cx->prepare('SELECT COUNT(*) FROM clientes_conexoes WHERE cliente_id=:id');
    $qtd->execute([':id'=>$cliente_id]);
    if (intval($qtd->fetchColumn()) >= intval($limite)) {
      return [ 'title' => 'Limite atingido para este cliente', 'icon' => 'warning' ];
    }
  }
  try {
    $st = $cx->prepare('INSERT INTO clientes_conexoes (cliente_id, conexao_id) VALUES (:cid,:xid)');
    $st->execute([':cid'=>$cliente_id, ':xid'=>$conexao_id]);
  } catch (Throwable $e) {
    return [ 'title' => 'Já vinculado ou inválido', 'icon' => 'info' ];
  }
  return [ 'title' => 'Conexão atribuída ao cliente', 'icon' => 'success' ];
}
function cc_remover($cliente_id, $conexao_id) {
  $cx = conectar_bd();
  $st = $cx->prepare('DELETE FROM clientes_conexoes WHERE cliente_id=:cid AND conexao_id=:xid');
  $st->execute([':cid'=>$cliente_id, ':xid'=>$conexao_id]);
  return [ 'title' => 'Conexão removida do cliente', 'icon' => 'success' ];
}
function cc_definir_limite($cliente_id, $limite) {
  $cx = conectar_bd();
  $st = $cx->prepare('UPDATE clientes SET limite_conexoes = :lim WHERE id=:id');
  $st->execute([':lim'=>($limite === '' ? null : $limite), ':id'=>$cliente_id]);
  return [ 'title' => 'Limite atualizado', 'icon' => 'success' ];
}