<?php
function listar_conexoes() {
  $cx = conectar_bd();
  $stmt = $cx->query('SELECT * FROM conexoes_m3u ORDER BY id DESC');
  return [ 'data' => $stmt->fetchAll(PDO::FETCH_ASSOC) ];
}
function validar_payload_conexao(&$p) {
  $p['nome'] = trim($p['nome'] ?? '');
  $p['tipo'] = in_array(($p['tipo'] ?? 'xtream'), ['xtream','m3u']) ? $p['tipo'] : 'xtream';
  $p['dominio'] = trim($p['dominio'] ?? '');
  $p['usuario'] = trim($p['usuario'] ?? '');
  $p['senha'] = trim($p['senha'] ?? '');
  $p['caminho'] = trim($p['caminho'] ?? '');
  $p['ativo'] = isset($p['ativo']) ? (intval($p['ativo']) ? 1 : 0) : 1;
  if ($p['nome'] === '' || $p['dominio'] === '') {
    return [ 'title' => 'Preencha nome e domínio', 'icon' => 'warning' ];
  }
  return null;
}
function adicionar_conexao($post) {
  if ($err = validar_payload_conexao($post)) return $err;
  $cx = conectar_bd();
  $sql = 'INSERT INTO conexoes_m3u (nome,tipo,dominio,usuario,senha,caminho,ativo,criado_por) VALUES (:nome,:tipo,:dominio,:usuario,:senha,:caminho,:ativo,:criado_por)';
  $st = $cx->prepare($sql);
  $st->execute([
    ':nome'=>$post['nome'], ':tipo'=>$post['tipo'], ':dominio'=>$post['dominio'],
    ':usuario'=>$post['usuario'] ?: null, ':senha'=>$post['senha'] ?: null,
    ':caminho'=>$post['caminho'] ?: null, ':ativo'=>$post['ativo'],
    ':criado_por'=>($_SESSION['admin_id'] ?? null)
  ]);
  return [ 'title' => 'Conexão adicionada', 'icon' => 'success' ];
}
function editar_conexao($post) {
  $id = intval($post['id'] ?? 0);
  if ($id <= 0) return [ 'title' => 'ID inválido', 'icon' => 'error' ];
  if ($err = validar_payload_conexao($post)) return $err;
  $cx = conectar_bd();
  $sql = 'UPDATE conexoes_m3u SET nome=:nome, tipo=:tipo, dominio=:dominio, usuario=:usuario, senha=:senha, caminho=:caminho, ativo=:ativo WHERE id=:id';
  $st = $cx->prepare($sql);
  $st->execute([
    ':id'=>$id,
    ':nome'=>$post['nome'], ':tipo'=>$post['tipo'], ':dominio'=>$post['dominio'],
    ':usuario'=>$post['usuario'] ?: null, ':senha'=>$post['senha'] ?: null,
    ':caminho'=>$post['caminho'] ?: null, ':ativo'=>$post['ativo']
  ]);
  return [ 'title' => 'Conexão atualizada', 'icon' => 'success' ];
}
function deletar_conexao($id) {
  if ($id <= 0) return [ 'title' => 'ID inválido', 'icon' => 'error' ];
  $cx = conectar_bd();
  $st = $cx->prepare('DELETE FROM conexoes_m3u WHERE id=:id');
  $st->execute([':id'=>$id]);
  return [ 'title' => 'Conexão removida', 'icon' => 'success' ];
}