<?php
session_start();
require_once("menu.php");
if (!isset($_SESSION['nivel_admin']) || $_SESSION['nivel_admin'] !== '1') {
  echo '<div class="alert alert-danger m-4">Acesso permitido apenas ao superadmin.</div>';
  exit;
}
?>
<h4 class="align-items-center d-flex justify-content-between mb-4 text-muted text-uppercase">
  Conexões M3U / XTREAM
  <button type="button" class="btn btn-outline-success fa-plus fw-bold" onclick="openFormConexao()">Adicionar</button>
</h4>
<table id="table_conexoes" class="display table" style="width: 100%">
  <thead class="table-dark">
    <tr>
      <th>#</th>
      <th>Nome</th>
      <th>Tipo</th>
      <th>Domínio</th>
      <th>Usuário</th>
      <th>Ativo</th>
      <th>Ações</th>
    </tr>
  </thead>
  <tbody></tbody>
</table>

<div class="modal fade" id="modalConexao" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Conexão</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form id="formConexao" onsubmit="event.preventDefault(); salvarConexao();">
          <input type="hidden" name="id" id="cx_id">
          <div class="mb-2">
            <label class="form-label">Nome</label>
            <input class="form-control" name="nome" id="cx_nome" required>
          </div>
          <div class="row g-2">
            <div class="col-6">
              <label class="form-label">Tipo</label>
              <select class="form-select" name="tipo" id="cx_tipo" onchange="toggleCampos()">
                <option value="xtream">XTREAM</option>
                <option value="m3u">M3U</option>
              </select>
            </div>
            <div class="col-6">
              <label class="form-label">Ativo</label>
              <select class="form-select" name="ativo" id="cx_ativo">
                <option value="1">Sim</option>
                <option value="0">Não</option>
              </select>
            </div>
          </div>
          <div class="mb-2">
            <label class="form-label">Domínio (ex.: http://servidor.com:8080)</label>
            <input class="form-control" name="dominio" id="cx_dominio" required>
          </div>
          <div id="xtream_fields" class="row g-2">
            <div class="col-6">
              <label class="form-label">Usuário</label>
              <input class="form-control" name="usuario" id="cx_usuario">
            </div>
            <div class="col-6">
              <label class="form-label">Senha</label>
              <input class="form-control" name="senha" id="cx_senha">
            </div>
          </div>
          <div id="m3u_fields" class="mb-2" style="display:none;">
            <label class="form-label">Caminho (ex.: /get.php?token=...)</label>
            <input class="form-control" name="caminho" id="cx_caminho">
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
        <button class="btn btn-primary" onclick="salvarConexao()">Salvar</button>
      </div>
    </div>
  </div>
</div>

<script>
function toggleCampos(){
  const tipo = document.getElementById('cx_tipo').value;
  document.getElementById('xtream_fields').style.display = (tipo==='xtream'?'flex':'none');
  document.getElementById('m3u_fields').style.display = (tipo==='m3u'?'block':'none');
}
function openFormConexao(){
  document.getElementById('formConexao').reset();
  document.getElementById('cx_id').value='';
  document.getElementById('cx_tipo').value='xtream';
  toggleCampos();
  var myModal = new bootstrap.Modal(document.getElementById('modalConexao'));
  myModal.show();
}
function editarConexao(row){
  document.getElementById('cx_id').value = row.id;
  document.getElementById('cx_nome').value = row.nome;
  document.getElementById('cx_tipo').value = row.tipo;
  document.getElementById('cx_dominio').value = row.dominio;
  document.getElementById('cx_usuario').value = row.usuario||'';
  document.getElementById('cx_senha').value = row.senha||'';
  document.getElementById('cx_caminho').value = row.caminho||'';
  document.getElementById('cx_ativo').value = row.ativo;
  toggleCampos();
  var myModal = new bootstrap.Modal(document.getElementById('modalConexao'));
  myModal.show();
}
function salvarConexao(){
  const fd = new FormData(document.getElementById('formConexao'));
  const id = fd.get('id');
  fd.append('action', id? 'editar':'adicionar');
  fetch('api/conexoes.php', { method:'POST', body: fd })
    .then(r=>r.json()).then(resp=>{ alert(resp.title||'OK'); carregarConexoes(); })
}
function deletarConexao(id){
  if(!confirm('Remover esta conexão?')) return;
  const fd = new FormData(); fd.append('action','deletar'); fd.append('id', id);
  fetch('api/conexoes.php', { method:'POST', body: fd })
    .then(r=>r.json()).then(resp=>{ alert(resp.title||'OK'); carregarConexoes(); })
}
function carregarConexoes(){
  const tbody = document.querySelector('#table_conexoes tbody');
  tbody.innerHTML = '<tr><td colspan="7">Carregando...</td></tr>';
  const fd = new FormData(); fd.append('action','listar');
  fetch('api/conexoes.php', { method:'POST', body: fd })
    .then(r=>r.json()).then(resp=>{
      tbody.innerHTML='';
      (resp.data||[]).forEach(row=>{
        const tr = document.createElement('tr');
        tr.innerHTML = `
          <td>${row.id}</td>
          <td>${row.nome}</td>
          <td>${row.tipo}</td>
          <td>${row.dominio}</td>
          <td>${row.usuario||''}</td>
          <td>${row.ativo=='1'?'Sim':'Não'}</td>
          <td>
            <button class="btn btn-sm btn-outline-primary" onclick='editarConexao(${JSON.stringify(row)})'>Editar</button>
            <button class="btn btn-sm btn-outline-danger" onclick='deletarConexao(${row.id})'>Excluir</button>
          </td>`;
        tbody.appendChild(tr);
      });
    });
}
document.addEventListener('DOMContentLoaded', carregarConexoes);
</script>