-- (mesmo conteúdo enviado antes; schema completo limpo)
SET NAMES utf8mb4;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
CREATE TABLE IF NOT EXISTS admin ( id INT AUTO_INCREMENT PRIMARY KEY, user VARCHAR(100) NOT NULL UNIQUE, pass VARCHAR(255) NOT NULL, token VARCHAR(255) DEFAULT NULL, admin TINYINT(1) NOT NULL DEFAULT 0, criado_por INT DEFAULT NULL, plano INT DEFAULT NULL, creditos DECIMAL(10,2) DEFAULT 0, criado_em TIMESTAMP DEFAULT CURRENT_TIMESTAMP, atualizado_em TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP, INDEX (token), INDEX (criado_por) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE IF NOT EXISTS planos ( id INT AUTO_INCREMENT PRIMARY KEY, admin_id INT DEFAULT NULL, nome VARCHAR(120) NOT NULL, valor DECIMAL(10,2) NOT NULL DEFAULT 0, custo_por_credito DECIMAL(10,2) NOT NULL DEFAULT 0, ativo TINYINT(1) NOT NULL DEFAULT 1, criado_em TIMESTAMP DEFAULT CURRENT_TIMESTAMP, atualizado_em TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP, CONSTRAINT fk_planos_admin FOREIGN KEY (admin_id) REFERENCES admin(id) ON DELETE SET NULL ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE IF NOT EXISTS categoria ( id INT AUTO_INCREMENT PRIMARY KEY, nome VARCHAR(150) NOT NULL, is_adult TINYINT(1) NOT NULL DEFAULT 0, type ENUM('canais','filmes','series') NOT NULL DEFAULT 'canais', ordem INT DEFAULT 0 ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE IF NOT EXISTS streams ( id INT AUTO_INCREMENT PRIMARY KEY, name VARCHAR(255) NOT NULL, url TEXT, logo TEXT, category_id INT DEFAULT NULL, is_adult TINYINT(1) NOT NULL DEFAULT 0, tipo ENUM('canal','filme') NOT NULL DEFAULT 'canal', descricao TEXT, elenco TEXT, direcao TEXT, ano VARCHAR(10), duracao VARCHAR(20), rating DECIMAL(3,1) DEFAULT NULL, criado_em TIMESTAMP DEFAULT CURRENT_TIMESTAMP, atualizado_em TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP, CONSTRAINT fk_streams_categoria FOREIGN KEY (category_id) REFERENCES categoria(id) ON DELETE SET NULL ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE IF NOT EXISTS series ( id INT AUTO_INCREMENT PRIMARY KEY, name VARCHAR(255) NOT NULL, overview TEXT, poster TEXT, backdrop TEXT, category_id INT DEFAULT NULL, is_adult TINYINT(1) NOT NULL DEFAULT 0, criado_em TIMESTAMP DEFAULT CURRENT_TIMESTAMP, atualizado_em TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP, CONSTRAINT fk_series_categoria FOREIGN KEY (category_id) REFERENCES categoria(id) ON DELETE SET NULL ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE IF NOT EXISTS series_seasons ( id INT AUTO_INCREMENT PRIMARY KEY, series_id INT NOT NULL, season_number INT NOT NULL, name VARCHAR(255), overview TEXT, cover TEXT, criado_em TIMESTAMP DEFAULT CURRENT_TIMESTAMP, atualizado_em TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP, CONSTRAINT fk_seasons_series FOREIGN KEY (series_id) REFERENCES series(id) ON DELETE CASCADE ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE IF NOT EXISTS series_episodes ( id INT AUTO_INCREMENT PRIMARY KEY, series_id INT NOT NULL, season_id INT NOT NULL, season_number INT NOT NULL, episode_num INT NOT NULL, name VARCHAR(255), overview TEXT, url TEXT, runtime_min INT DEFAULT NULL, criado_em TIMESTAMP DEFAULT CURRENT_TIMESTAMP, atualizado_em TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP, CONSTRAINT fk_episodes_series  FOREIGN KEY (series_id) REFERENCES series(id) ON DELETE CASCADE, CONSTRAINT fk_episodes_season  FOREIGN KEY (season_id) REFERENCES series_seasons(id) ON DELETE CASCADE ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE IF NOT EXISTS devices_apps ( id INT AUTO_INCREMENT PRIMARY KEY, device_name VARCHAR(120) NOT NULL, app_name VARCHAR(120) NOT NULL ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE IF NOT EXISTS clientes ( id INT AUTO_INCREMENT PRIMARY KEY, admin_id INT DEFAULT NULL, name VARCHAR(180) NOT NULL, usuario VARCHAR(120) DEFAULT NULL, senha VARCHAR(120) DEFAULT NULL, fonte VARCHAR(120) DEFAULT NULL, usuario0 VARCHAR(120) DEFAULT NULL, senha0 VARCHAR(120) DEFAULT NULL, adulto TINYINT(1) DEFAULT 0, plano INT DEFAULT NULL, dispositivo VARCHAR(120) DEFAULT NULL, app VARCHAR(120) DEFAULT NULL, forma_pagamento VARCHAR(120) DEFAULT NULL, nome_do_pagador VARCHAR(180) DEFAULT NULL, whatsapp VARCHAR(40)  DEFAULT NULL, email_app VARCHAR(180) DEFAULT NULL, indicacao INT DEFAULT NULL, device_mac VARCHAR(60)  DEFAULT NULL, data_app VARCHAR(60)  DEFAULT NULL, senha_app VARCHAR(60)  DEFAULT NULL, vencimento DATETIME DEFAULT NULL, conexoes INT DEFAULT 1, limite_conexoes INT DEFAULT NULL, ativo TINYINT(1) NOT NULL DEFAULT 1, criado_em TIMESTAMP DEFAULT CURRENT_TIMESTAMP, atualizado_em TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP, CONSTRAINT fk_clientes_admin FOREIGN KEY (admin_id) REFERENCES admin(id) ON DELETE SET NULL, CONSTRAINT fk_clientes_plano FOREIGN KEY (plano) REFERENCES planos(id) ON DELETE SET NULL ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE IF NOT EXISTS conexoes_m3u ( id INT AUTO_INCREMENT PRIMARY KEY, nome VARCHAR(100) NOT NULL, tipo ENUM('xtream','m3u') NOT NULL DEFAULT 'xtream', dominio VARCHAR(255) NOT NULL, usuario VARCHAR(120) DEFAULT NULL, senha VARCHAR(120) DEFAULT NULL, caminho VARCHAR(255) DEFAULT NULL, ativo TINYINT(1) NOT NULL DEFAULT 1, criado_por INT DEFAULT NULL, criado_em TIMESTAMP DEFAULT CURRENT_TIMESTAMP, atualizado_em TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP, CONSTRAINT fk_conexao_admin FOREIGN KEY (criado_por) REFERENCES admin(id) ON DELETE SET NULL ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE IF NOT EXISTS clientes_conexoes ( id INT AUTO_INCREMENT PRIMARY KEY, cliente_id INT NOT NULL, conexao_id INT NOT NULL, criado_em TIMESTAMP DEFAULT CURRENT_TIMESTAMP, UNIQUE KEY uq_cliente_conexao (cliente_id, conexao_id), CONSTRAINT fk_cc_cliente FOREIGN KEY (cliente_id) REFERENCES clientes(id) ON DELETE CASCADE, CONSTRAINT fk_cc_conexao FOREIGN KEY (conexao_id) REFERENCES conexoes_m3u(id) ON DELETE CASCADE ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
SET foreign_key_checks = 1;