(function(){
  function renderCard(cid){
    if(!cid) return;
    var card = `
<div class="card mt-3" id="card-conexoes-cliente">
  <div class="card-header d-flex justify-content-between align-items-center">
    <span>Conexões deste cliente</span>
    <div class="d-flex gap-2">
      <input type="number" min="1" class="form-control form-control-sm" id="limite_conexoes" placeholder="Limite (opcional)" style="max-width:160px;">
      <button class="btn btn-sm btn-outline-primary" id="btn-salvar-limite">Salvar limite</button>
    </div>
  </div>
  <div class="card-body">
    <div class="mb-2 d-flex gap-2">
      <select class="form-select" id="selectConexao" style="max-width:420px;"></select>
      <button class="btn btn-success" id="btn-anexar">Atribuir</button>
    </div>
    <ul class="list-group" id="listaConexoes"></ul>
  </div>
</div>`;
    // Onde injetar: tenta após #modal_master-body, senão ao final do body do modal
    var $body = $("#modal_master-body");
    if($body.length){ $body.append(card); }
    else { $(".modal .modal-body").last().append(card); }

    // Handlers
    $("#btn-salvar-limite").off("click").on("click", function(){
      var lim = $("#limite_conexoes").val();
      $.post("api/clientes_conexoes.php", { action:"definir_limite", cliente_id: cid, limite: lim }, function(r){
        alert(r.title||"OK");
      },"json");
    });
    $("#btn-anexar").off("click").on("click", function(){
      var xid = $("#selectConexao").val();
      $.post("api/clientes_conexoes.php", { action:"anexar", cliente_id: cid, conexao_id: xid }, function(r){
        alert(r.title||"OK");
        loadConexoesDoCliente(cid);
      },"json");
    });

    // Carregar dados
    loadConexoesDisponiveis();
    loadConexoesDoCliente(cid);
  }

  function loadConexoesDisponiveis(){
    $.post("api/conexoes.php", { action:"listar" }, function(resp){
      var $sel = $("#selectConexao"); $sel.empty();
      (resp.data||[]).forEach(function(r){
        $sel.append(`<option value="${r.id}">${r.nome} — ${r.dominio}</option>`);
      });
    },"json");
  }

  function loadConexoesDoCliente(cid){
    $.post("api/clientes_conexoes.php", { action:"listar_por_cliente", cliente_id: cid }, function(resp){
      var $ul = $("#listaConexoes"); $ul.empty();
      (resp.data||[]).forEach(function(r){
        var li = $(`<li class="list-group-item d-flex justify-content-between align-items-center">
          <span>${r.nome} <small class="text-muted">(${r.tipo})</small></span>
          <button class="btn btn-sm btn-outline-danger">Remover</button>
        </li>`);
        li.find("button").on("click", function(){
          $.post("api/clientes_conexoes.php", { action:"remover", cliente_id: cid, conexao_id: r.id }, function(r2){
            alert(r2.title||"OK");
            loadConexoesDoCliente(cid);
          },"json");
        });
        $ul.append(li);
      });
    },"json");
  }

  // Hook: sempre que o modal abrir, tenta montar o card.
  $(document).on("shown.bs.modal", function(){
    // tenta achar id do cliente no formulário do modal
    var cid = $("#id_c").val() || $("#cliente_id").val() || $("input[name='id_c']").val();
    // evita duplicar
    if($("#card-conexoes-cliente").length===0){
      renderCard(parseInt(cid||0,10));
    }
  });
})();