CREATE TABLE IF NOT EXISTS conexoes_m3u (
  id INT AUTO_INCREMENT PRIMARY KEY,
  nome VARCHAR(100) NOT NULL,
  tipo ENUM('xtream','m3u') NOT NULL DEFAULT 'xtream',
  dominio VARCHAR(255) NOT NULL,
  usuario VARCHAR(120) DEFAULT NULL,
  senha VARCHAR(120) DEFAULT NULL,
  caminho VARCHAR(255) DEFAULT NULL,
  ativo TINYINT(1) NOT NULL DEFAULT 1,
  criado_por INT DEFAULT NULL,
  criado_em TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  atualizado_em TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

ALTER TABLE clientes ADD COLUMN IF NOT EXISTS limite_conexoes INT DEFAULT NULL;

CREATE TABLE IF NOT EXISTS clientes_conexoes (
  id INT AUTO_INCREMENT PRIMARY KEY,
  cliente_id INT NOT NULL,
  conexao_id INT NOT NULL,
  criado_em TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  UNIQUE KEY uq_cliente_conexao (cliente_id, conexao_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;